/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.PathedParticleManager;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.Color;
import com.fantasticsource.tools.datastructures.VectorN;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PathedParticle
extends Particle {
    protected boolean readyToRender = false;
    public double u1 = 0.25;
    public double v1 = 0.125;
    public double u2 = 0.5;
    public double v2 = 0.375;
    public boolean useBlockLight = false;
    public double xScale3D = 1.0;
    public double yScale3D = 1.0;
    public double zScale3D = 1.0;
    protected CPath.CPathData basePath;
    protected CPath.CPathData rgbPath = null;
    protected CPath.CPathData hsvPath = null;
    protected CPath.CPathData alphaPath = null;
    protected CPath.CPathData scale3DPath = null;
    protected ArrayList<CPath.CPathData> morePaths = new ArrayList();

    public PathedParticle(CPath basePath, CPath ... morePaths) {
        this(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, basePath, morePaths);
    }

    public PathedParticle(GlStateManager.SourceFactor sourceBlend, GlStateManager.DestFactor destBlend, CPath basePath, CPath ... morePaths) {
        super((World)Minecraft.func_71410_x().field_71441_e, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.basePath = new CPath.CPathData(basePath);
        for (CPath path : morePaths) {
            this.applyPath(path);
        }
        VectorN pos = this.currentPos();
        this.func_187109_b(pos.values[0], pos.values[1], pos.values[2]);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_70547_e = 60;
        this.field_70544_f = 1.0f;
        this.field_190017_n = false;
        PathedParticleManager.add(this, sourceBlend, destBlend);
    }

    public PathedParticle applyPath(CPath path) {
        this.morePaths.add(new CPath.CPathData(path));
        return this;
    }

    public PathedParticle useBlockLight(boolean useBlockLight) {
        this.useBlockLight = useBlockLight;
        return this;
    }

    public PathedParticle rgbPath(CPath path) {
        this.rgbPath = new CPath.CPathData(path);
        return this;
    }

    public PathedParticle hsvPath(CPath path) {
        this.hsvPath = new CPath.CPathData(path);
        return this;
    }

    public PathedParticle alphaPath(CPath path) {
        this.alphaPath = new CPath.CPathData(path);
        return this;
    }

    public PathedParticle scale3DPath(CPath path) {
        this.scale3DPath = new CPath.CPathData(path);
        return this;
    }

    public void func_189213_a() {
        if (this.field_70546_d++ > this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        VectorN pos = this.currentPos();
        if (pos == null) {
            this.func_187112_i();
            return;
        }
        this.func_187109_b(pos.values[0], pos.values[1], pos.values[2]);
        if (this.rgbPath != null) {
            VectorN rgb = this.rgbPath.getRelativePosition();
            this.func_70538_b((float)rgb.values[0], (float)rgb.values[1], (float)rgb.values[2]);
        } else if (this.hsvPath != null) {
            VectorN hsv = this.hsvPath.getRelativePosition();
            Color c = new Color(0).setColorHSV((float)hsv.values[0], (float)hsv.values[1], (float)hsv.values[2]);
            this.func_70538_b(c.rf(), c.gf(), c.bf());
        }
        if (this.alphaPath != null) {
            this.func_82338_g((float)this.alphaPath.getRelativePosition().values[0]);
        }
        if (this.scale3DPath != null) {
            VectorN scalar = this.scale3DPath.getRelativePosition();
            this.xScale3D = scalar.values[0];
            this.yScale3D = scalar.values[1];
            this.zScale3D = scalar.values[2];
        }
        this.readyToRender = true;
    }

    protected VectorN currentPos() {
        VectorN pos = this.basePath.getRelativePosition();
        for (CPath.CPathData data : this.morePaths) {
            VectorN pathPos = data.getRelativePosition();
            if (pathPos == null) {
                return null;
            }
            pos.add(pathPos);
        }
        return pos;
    }

    public int func_189214_a(float p_189214_1_) {
        if (this.useBlockLight) {
            return super.func_189214_a(p_189214_1_);
        }
        return 0xF000F0;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.readyToRender) {
            return;
        }
        double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an;
        double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao;
        double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap;
        double scale = this.field_70544_f / 2.0f;
        Vec3d[] vecs = new Vec3d[]{new Vec3d((double)(-rotationX - rotationXY) * this.xScale3D, (double)(-rotationZ) * this.yScale3D, (double)(-rotationYZ - rotationXZ) * this.zScale3D).func_186678_a(scale), new Vec3d((double)(-rotationX + rotationXY) * this.xScale3D, (double)rotationZ * this.yScale3D, (double)(-rotationYZ + rotationXZ) * this.zScale3D).func_186678_a(scale), new Vec3d((double)(rotationX + rotationXY) * this.xScale3D, (double)rotationZ * this.yScale3D, (double)(rotationYZ + rotationXZ) * this.zScale3D).func_186678_a(scale), new Vec3d((double)(rotationX - rotationXY) * this.xScale3D, (double)(-rotationZ) * this.yScale3D, (double)(rotationYZ - rotationXZ) * this.zScale3D).func_186678_a(scale)};
        if (this.field_190014_F != 0.0f) {
            float theta = (this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks) * 0.5f;
            float cosTheta = MathHelper.func_76134_b((float)theta);
            double xx = (double)MathHelper.func_76126_a((float)theta) * PathedParticle.field_190016_K.field_72450_a;
            double yy = (double)MathHelper.func_76126_a((float)theta) * PathedParticle.field_190016_K.field_72448_b;
            double zz = (double)MathHelper.func_76126_a((float)theta) * PathedParticle.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d(xx, yy, zz);
            for (int l = 0; l < 4; ++l) {
                vecs[l] = vec3d.func_186678_a(2.0 * vecs[l].func_72430_b(vec3d)).func_178787_e(vecs[l].func_186678_a((double)(cosTheta * cosTheta) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(vecs[l]).func_186678_a((double)(2.0f * cosTheta)));
            }
        }
        int lightmapIndex = this.func_189214_a(partialTicks);
        int lightmapX = lightmapIndex >> 16 & 0xFFFF;
        int lightmapY = lightmapIndex & 0xFFFF;
        buffer.func_181662_b(x + vecs[0].field_72450_a, y + vecs[0].field_72448_b, z + vecs[0].field_72449_c).func_187315_a(this.u2, this.v2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buffer.func_181662_b(x + vecs[1].field_72450_a, y + vecs[1].field_72448_b, z + vecs[1].field_72449_c).func_187315_a(this.u2, this.v1).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buffer.func_181662_b(x + vecs[2].field_72450_a, y + vecs[2].field_72448_b, z + vecs[2].field_72449_c).func_187315_a(this.u1, this.v1).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buffer.func_181662_b(x + vecs[3].field_72450_a, y + vecs[3].field_72448_b, z + vecs[3].field_72449_c).func_187315_a(this.u1, this.v2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(lightmapX, lightmapY).func_181675_d();
    }
}

